/*
 * Decompiled with CFR 0.152.
 */
package jclass.table3;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import jclass.table3.Clip;
import jclass.table3.Draw;
import jclass.table3.JCCellPosition;
import jclass.table3.JCCellRange;
import jclass.table3.JCPrintEvent;
import jclass.table3.Size;
import jclass.table3.Table;
import jclass.table3.TableData;
import jclass.util.JCListenerList;
import jclass.util.JCVector;

public class JCPrintTable {
    Table table;
    Table print_table;
    int page_width;
    int page_height;
    int page_resolution = 72;
    int table_width;
    int table_height;
    Insets margin = new Insets(72, 72, 72, 72);
    int margin_unit = 1;
    public static final int MARGIN_IN_INCHES = 0;
    public static final int MARGIN_IN_PIXELS = 1;
    int current_page;

    public JCPrintTable(Table table) {
        this.table = table;
        this.print_table = new Table();
        this.print_table.setPrinting(true);
        Clip.setPrintTable(this);
        this.setupPrintTable();
    }

    public void paintPage(Graphics graphics, int n) {
        this.print_table.setDoubleBuffer(false);
        this.current_page = n;
        JCCellRange jCCellRange = this.getPageCellRange(n);
        Dimension dimension = this.getTablePageDimension(jCCellRange);
        this.print_table.reshape(0, 0, dimension.width, dimension.height);
        graphics.setFont(new Font("Dialog", 0, 12));
        graphics.setColor(Color.white);
        this.print_table.paint(graphics, jCCellRange);
        this.print_table.setDoubleBuffer(true);
    }

    public void paintPage(Graphics graphics, JCCellRange jCCellRange) {
        int n;
        int n2;
        int n3;
        int n4;
        int n5;
        Dimension dimension = new Dimension(0, 0);
        dimension.width = this.print_table.getColumnPixelWidth(-1) + this.print_table.frozenColumnWidth() + this.print_table.columnPosition(jCCellRange.end_column) - this.print_table.columnPosition(jCCellRange.start_column) + this.print_table.getColumnPixelWidth(jCCellRange.end_column);
        dimension.height = this.print_table.getRowPixelHeight(-1) + this.print_table.frozenRowHeight() + this.print_table.rowPosition(jCCellRange.end_row) - this.print_table.rowPosition(jCCellRange.start_row) + this.print_table.getRowPixelHeight(jCCellRange.end_row);
        graphics.setColor(Color.white);
        graphics.fillRect(0, 0, this.page_width, this.page_height);
        Point point = this.getTableOffset();
        graphics.setClip(point.x, point.y, this.table_width, this.table_height);
        if (this.print_table.span.span_list.size() != 0) {
            this.splitSpans(jCCellRange);
        }
        if ((n5 = this.print_table.getFrozenColumns()) > 0) {
            n4 = 0;
            while (n4 < n5) {
                Draw.cell(this.print_table, -1, n4);
                ++n4;
            }
        }
        n4 = jCCellRange.start_column;
        while (n4 <= jCCellRange.end_column) {
            Draw.cell(this.print_table, -1, n4);
            ++n4;
        }
        int n6 = this.print_table.getFrozenRows();
        if (n6 > 0) {
            n3 = 0;
            while (n3 < n6) {
                Draw.cell(this.print_table, n3, -1);
                ++n3;
            }
        }
        n3 = jCCellRange.start_row;
        while (n3 <= jCCellRange.end_row) {
            Draw.cell(this.print_table, n3, -1);
            ++n3;
        }
        if (n5 > 0 && n6 > 0) {
            n2 = 0;
            while (n2 < n6) {
                n = 0;
                while (n < n5) {
                    Draw.cell(this.print_table, n2, n);
                    ++n;
                }
                ++n2;
            }
        }
        if (n5 > 0) {
            n2 = jCCellRange.start_row;
            while (n2 <= jCCellRange.end_row) {
                n = 0;
                while (n < n5) {
                    Draw.cell(this.print_table, n2, n);
                    ++n;
                }
                ++n2;
            }
        }
        if (n6 > 0) {
            n2 = 0;
            while (n2 < n6) {
                n = jCCellRange.start_column;
                while (n <= jCCellRange.end_column) {
                    Draw.cell(this.print_table, n2, n);
                    ++n;
                }
                ++n2;
            }
        }
        n2 = jCCellRange.start_row;
        while (n2 <= jCCellRange.end_row) {
            n = jCCellRange.start_column;
            while (n <= jCCellRange.end_column) {
                Draw.cell(this.print_table, n2, n);
                ++n;
            }
            ++n2;
        }
        this.doPrintPageHeader(graphics, this.current_page);
        if (this.current_page == this.getNumPages() - 1) {
            Point point2 = new Point(0, 0);
            Point point3 = this.getPosition(jCCellRange, jCCellRange.end_row, jCCellRange.end_column, point2);
            this.doPrintEnd(graphics, this.current_page, point3.y + this.print_table.getRowPixelHeight(jCCellRange.end_row));
        }
        this.doPrintBody(graphics, this.current_page);
        this.doPrintPageFooter(graphics, this.current_page);
    }

    public Point getPosition(JCCellRange jCCellRange, int n, int n2, Point point) {
        int n3 = this.print_table.getFrozenColumns();
        int n4 = this.print_table.getFrozenRows();
        if (n == -1) {
            if (n2 < n3) {
                point.x = this.print_table.row_label_placement == 0 ? (this.print_table.frozen_column_placement == 0 ? this.getRowLabelWidth() : this.print_table.size().width - this.print_table.frozenColumnWidth()) : (this.print_table.frozen_column_placement == 0 ? 0 : this.print_table.size().width - this.getRowLabelWidth() - this.print_table.frozenColumnWidth());
                point.x += this.print_table.columnPosition(n2) - this.print_table.columnPosition(0);
            } else {
                point.x = this.print_table.row_label_placement == 0 ? this.getRowLabelWidth() : 0;
                if (n3 > 0 && this.print_table.frozen_column_placement == 0) {
                    point.x += this.print_table.frozenColumnWidth();
                }
                point.x += this.print_table.columnPosition(n2) - this.print_table.columnPosition(jCCellRange.start_column);
            }
            point.y = this.print_table.column_label_placement == 0 ? 0 : this.print_table.size().height - this.getColumnLabelHeight();
        } else if (n2 == -1) {
            point.x = this.print_table.row_label_placement == 0 ? 0 : this.print_table.size().width - this.getRowLabelWidth();
            if (n < n4) {
                point.y = this.print_table.column_label_placement == 0 ? (this.print_table.frozen_row_placement == 0 ? this.getColumnLabelHeight() : this.print_table.size().height - this.print_table.frozenRowHeight()) : (this.print_table.frozen_row_placement == 0 ? 0 : this.print_table.size().height - this.getColumnLabelHeight() - this.print_table.frozenRowHeight());
                point.y += this.print_table.rowPosition(n) - this.print_table.rowPosition(0);
            } else {
                point.y = this.print_table.column_label_placement == 0 ? this.getColumnLabelHeight() : 0;
                if (n4 > 0 && this.print_table.frozen_row_placement == 0) {
                    point.y += this.print_table.frozenRowHeight();
                }
                point.y += this.print_table.rowPosition(n) - this.print_table.rowPosition(jCCellRange.start_row);
            }
        } else {
            if (n2 < n3) {
                point.x = this.print_table.row_label_placement == 0 ? (this.print_table.frozen_column_placement == 0 ? this.getRowLabelWidth() : this.print_table.size().width - this.print_table.frozenColumnWidth()) : (this.print_table.frozen_column_placement == 0 ? 0 : this.print_table.size().width - this.getRowLabelWidth() - this.print_table.frozenColumnWidth());
                point.x += this.print_table.columnPosition(n2) - this.print_table.columnPosition(0);
            } else {
                point.x = this.print_table.row_label_placement == 0 ? this.getRowLabelWidth() : 0;
                if (n3 > 0 && this.print_table.frozen_column_placement == 0) {
                    point.x += this.print_table.frozenColumnWidth();
                }
                point.x += this.print_table.columnPosition(n2) - this.print_table.columnPosition(jCCellRange.start_column);
            }
            if (n < n4) {
                point.y = this.print_table.column_label_placement == 0 ? (this.print_table.frozen_row_placement == 0 ? this.getColumnLabelHeight() : this.print_table.size().height - this.print_table.frozenRowHeight()) : (this.print_table.frozen_row_placement == 0 ? 0 : this.print_table.size().height - this.getColumnLabelHeight() - this.print_table.frozenRowHeight());
                point.y += this.print_table.rowPosition(n) - this.print_table.rowPosition(0);
            } else {
                point.y = this.print_table.column_label_placement == 0 ? this.getColumnLabelHeight() : 0;
                if (n4 > 0 && this.print_table.frozen_row_placement == 0) {
                    point.y += this.print_table.frozenRowHeight();
                }
                point.y += this.print_table.rowPosition(n) - this.print_table.rowPosition(jCCellRange.start_row);
            }
        }
        Point point2 = this.getTableOffset();
        point.x += point2.x;
        point.y += point2.y;
        return point;
    }

    public void setupPrintTable() {
        TableData tableData = this.table.getDataView().getDataSource();
        this.print_table.getDataView().setDataSource(tableData);
        if (this.print_table.bg_series.getDefault() == null) {
            this.print_table.bg_series.setDefault(this.table.getBackground());
        }
        if (this.print_table.fg_series.getDefault() == null) {
            this.print_table.fg_series.setDefault(this.table.getForeground());
        }
        if (this.print_table.font_series.getDefault() == null) {
            this.print_table.font_series.setDefault(this.table.getFont());
        }
        this.print_table.column_label_height = Size.getColumnLabelMaxHeight(this.table, -998, 0);
        this.print_table.row_label_width = Size.getRowLabelMaxWidth(this.table, -998, 0);
        Size.setDimensions(this.print_table, 7, this.print_table.getNumRows(), this.print_table.getNumColumns(), -998, 0, -998, 0, true);
        this.print_table.clip_arrows = this.table.clip_arrows;
        this.print_table.column_label_placement = this.table.column_label_placement;
        this.print_table.column_label_offset = this.table.column_label_offset;
        this.print_table.column_label_display = this.table.column_label_display;
        this.print_table.frame_bordertype = this.table.frame_bordertype;
        this.print_table.frame_shadow = this.table.frame_shadow;
        this.print_table.frozen_columns = this.table.frozen_columns;
        this.print_table.frozen_rows = this.table.frozen_rows;
        this.print_table.frozen_column_placement = this.table.frozen_column_placement;
        this.print_table.frozen_row_placement = this.table.frozen_row_placement;
        this.print_table.row_label_placement = this.table.row_label_placement;
        this.print_table.row_label_offset = this.table.row_label_offset;
        this.print_table.row_label_display = this.table.row_label_display;
        this.print_table.repeat_bg_colors = this.table.repeat_bg_colors;
        this.print_table.repeat_fg_colors = this.table.repeat_fg_colors;
        this.print_table.shadow_thickness = this.table.shadow_thickness;
        this.print_table.alignment_series = this.table.alignment_series;
        this.print_table.bg_series = this.table.bg_series;
        this.print_table.bordersides_series = this.table.bordersides_series;
        this.print_table.bordertype_series = this.table.bordertype_series;
        this.print_table.cellrenderer_series = this.table.cellrenderer_series;
        this.print_table.font_series = this.table.font_series;
        this.print_table.fg_series = this.table.fg_series;
        this.print_table.setSpans(this.table.getSpans());
        if (this.print_table.span.origSpanListSize() > 0) {
            this.print_table.span.copy();
            this.print_table.span.adjust();
        }
        this.print_table.dataView = this.table.dataView;
        int n = 0;
        while (n < this.table.getNumRows()) {
            this.print_table.setPixelHeight(n, this.table.getRowPixelHeight(n));
            ++n;
        }
        int n2 = 0;
        while (n2 < this.table.getNumColumns()) {
            this.print_table.setPixelWidth(n2, this.table.getColumnPixelWidth(n2));
            ++n2;
        }
        this.print_table.defaultCellAppearance = null;
        this.print_table.defaultCellBorder = null;
    }

    public int getMarginUnits() {
        return this.margin_unit;
    }

    public void setMarginUnits(int n) {
        if (this.margin_unit == 0) {
            this.margin_unit = 0;
            return;
        }
        this.margin_unit = 1;
    }

    public int getNumPages() {
        if (this.page_width * this.page_height == 0) {
            return 0;
        }
        return this.getNumColumnPages() * this.getNumRowPages();
    }

    public JCCellRange getPageCellRange(int n) {
        if (this.getNumPages() == 0) {
            return null;
        }
        JCCellPosition jCCellPosition = this.getPageStartCell(n);
        JCCellPosition jCCellPosition2 = this.getPageEndCell(n);
        return new JCCellRange(jCCellPosition.row, jCCellPosition.column, jCCellPosition2.row, jCCellPosition2.column);
    }

    public Dimension getPageDimensions() {
        return new Dimension(this.page_width, this.page_height);
    }

    public void setPageDimensions(int n, int n2) {
        if (n == 0 || n2 == 0) {
            n = 612;
            n2 = 792;
            this.page_resolution = 72;
        }
        this.page_width = n;
        this.page_height = n2;
        this.setInternalDimensions();
    }

    public int getPageHeight() {
        return this.page_height;
    }

    public void setPageHeight(int n) {
        this.page_height = n;
        this.setInternalDimensions();
    }

    public Insets getPageMargins() {
        return this.margin;
    }

    public Insets getDefaultPageMargins() {
        this.margin_unit = 1;
        this.margin = new Insets(72, 72, 72, 72);
        return this.margin;
    }

    public void setPageMargins(Insets insets) {
        if (insets == null) {
            insets = this.getDefaultPageMargins();
        } else {
            this.margin = insets;
        }
        this.setInternalDimensions();
    }

    public int getPageResolution() {
        return this.page_resolution;
    }

    public void setPageResolution(int n) {
        this.page_resolution = n;
        this.setInternalDimensions();
    }

    public int getPageWidth() {
        return this.page_width;
    }

    public void setPageWidth(int n) {
        this.page_width = n;
        this.setInternalDimensions();
    }

    private void splitSpans(JCCellRange jCCellRange) {
        int n = this.print_table.span.span_list.size();
        JCVector jCVector = new JCVector();
        int n2 = 0;
        while (n2 < n) {
            JCCellRange jCCellRange2 = (JCCellRange)this.print_table.span.span_list.elementAt(n2);
            JCCellRange jCCellRange3 = new JCCellRange(jCCellRange2.start_row, jCCellRange2.start_column, jCCellRange2.end_row, jCCellRange2.end_column);
            if (jCCellRange2.start_row < jCCellRange.start_row && jCCellRange2.end_row >= jCCellRange.end_row) {
                jCCellRange3.reshape(jCCellRange3.start_row, jCCellRange3.start_column, jCCellRange.start_row - 1, jCCellRange3.end_column);
            }
            if (jCCellRange2.start_row <= jCCellRange.end_row && jCCellRange2.end_row > jCCellRange.end_row) {
                jCCellRange3.reshape(jCCellRange3.start_row, jCCellRange3.start_column, jCCellRange.end_row, jCCellRange3.end_column);
            }
            if (jCCellRange2.start_column < jCCellRange.start_column && jCCellRange2.end_column >= jCCellRange.end_column) {
                jCCellRange3.reshape(jCCellRange3.start_row, jCCellRange3.start_column, jCCellRange3.end_row, jCCellRange.start_column - 1);
            }
            if (jCCellRange2.start_column <= jCCellRange.end_column && jCCellRange2.end_column > jCCellRange.end_column) {
                jCCellRange3.reshape(jCCellRange3.start_row, jCCellRange3.start_column, jCCellRange3.end_row, jCCellRange.end_column);
            }
            jCVector.addElement(jCCellRange3);
            ++n2;
        }
        this.print_table.setSpans(jCVector);
        if (this.print_table.span.origSpanListSize() > 0) {
            this.print_table.span.copy();
            this.print_table.span.adjust();
        }
    }

    private JCCellPosition getPageStartCell(int n) {
        int n2;
        int n3;
        int n4;
        int n5 = this.getNumColumnPages();
        this.getNumRowPages();
        int n6 = n / n5 + 1;
        int n7 = n % n5 + 1;
        int n8 = this.table.getFrozenRows();
        int n9 = this.table.getFrozenColumns();
        if (n7 == 1) {
            n9 = this.table.getFrozenColumns();
        } else {
            n4 = (this.table_width - this.table.row_label_width - this.table.frozenColumnWidth()) * (n7 - 1);
            n3 = 0;
            n2 = n9;
            while (n2 < this.table.getNumColumns()) {
                if ((n3 += this.table.getColumnPixelWidth(n2)) <= n4) {
                    n9 = n2;
                }
                ++n2;
            }
            ++n9;
        }
        if (n6 == 1) {
            n8 = this.table.getFrozenRows();
        } else {
            n4 = (this.table_height - this.table.column_label_height - this.table.frozenRowHeight()) * (n6 - 1);
            n3 = 0;
            n2 = n8;
            while (n2 < this.table.getNumRows()) {
                if ((n3 += this.table.getRowPixelHeight(n2)) <= n4) {
                    n8 = n2;
                }
                ++n2;
            }
            ++n8;
        }
        return new JCCellPosition(n8, n9);
    }

    private JCCellPosition getPageEndCell(int n) {
        int n2;
        int n3;
        int n4;
        int n5 = this.getNumColumnPages();
        int n6 = this.getNumRowPages();
        int n7 = n / n5 + 1;
        int n8 = n % n5 + 1;
        int n9 = this.table.getFrozenRows();
        int n10 = this.table.getFrozenColumns();
        if (n8 == n5) {
            n10 = this.table.getNumColumns() - 1;
        } else {
            n4 = (this.table_width - this.table.row_label_width - this.table.frozenColumnWidth()) * n8;
            n3 = 0;
            n2 = n10;
            while (n2 < this.table.getNumColumns()) {
                if ((n3 += this.table.getColumnPixelWidth(n2)) <= n4) {
                    n10 = n2;
                }
                ++n2;
            }
        }
        if (n7 == n6) {
            n9 = this.table.getNumRows() - 1;
        } else {
            n4 = (this.table_height - this.table.column_label_height - this.table.frozenRowHeight()) * n7;
            n3 = 0;
            n2 = n9;
            while (n2 < this.table.getNumRows()) {
                if ((n3 += this.table.getRowPixelHeight(n2)) <= n4) {
                    n9 = n2;
                }
                ++n2;
            }
        }
        return new JCCellPosition(n9, n10);
    }

    public int getNumHorizontalPages() {
        return this.getNumColumnPages();
    }

    private int getNumColumnPages() {
        int n = 1;
        int n2 = this.table.row_label_width;
        int n3 = this.table.frozenColumnWidth();
        if (n2 + n3 > this.table_width) {
            return 0;
        }
        int n4 = n2 + n3;
        int n5 = this.table.getFrozenColumns();
        while (n5 < this.table.getNumColumns()) {
            if ((n4 += this.table.getColumnPixelWidth(n5)) > this.table_width) {
                n4 = n2 + n3 + this.table.getColumnPixelWidth(n5);
                ++n;
            }
            ++n5;
        }
        return n;
    }

    public int getNumVerticalPages() {
        return this.getNumRowPages();
    }

    private int getNumRowPages() {
        int n = 1;
        int n2 = this.table.column_label_height;
        int n3 = this.table.frozenRowHeight();
        if (n2 + n3 > this.table_height) {
            return 0;
        }
        int n4 = n2 + n3;
        int n5 = this.table.getFrozenRows();
        while (n5 < this.table.getNumRows()) {
            if ((n4 += this.table.getRowPixelHeight(n5)) > this.table_height) {
                n4 = n2 + n3 + this.table.getRowPixelHeight(n5);
                ++n;
            }
            ++n5;
        }
        return n;
    }

    private Point getTableOffset() {
        int n = this.margin_unit == 0 ? this.page_resolution : 1;
        return new Point(n * this.margin.left, n * this.margin.top);
    }

    private Dimension getTablePageDimension(JCCellRange jCCellRange) {
        Dimension dimension = new Dimension(0, 0);
        dimension.width = this.getRowLabelWidth() + this.print_table.frozenColumnWidth() + this.print_table.columnPosition(jCCellRange.end_column) - this.print_table.columnPosition(jCCellRange.start_column) + this.print_table.getColumnPixelWidth(jCCellRange.end_column);
        dimension.height = this.getColumnLabelHeight() + this.print_table.frozenRowHeight() + this.print_table.rowPosition(jCCellRange.end_row) - this.print_table.rowPosition(jCCellRange.start_row) + this.print_table.getRowPixelHeight(jCCellRange.end_row);
        return dimension;
    }

    public Dimension getTableDimensions(int n) {
        return this.getTablePageDimension(this.getPageCellRange(n));
    }

    private void setInternalDimensions() {
        int n = this.margin_unit == 0 ? this.page_resolution : 1;
        this.table_width = this.page_width - n * (this.margin.left + this.margin.right);
        this.table_height = this.page_height - n * (this.margin.top + this.margin.bottom);
    }

    private void doPrintPageHeader(Graphics graphics, int n) {
        Graphics graphics2 = graphics.create();
        int n2 = this.margin_unit == 0 ? this.page_resolution : 1;
        graphics2.setClip(n2 * this.margin.left, 0, this.table_width, n2 * this.margin.top);
        graphics2.translate(n2 * this.margin.left, 0);
        JCPrintEvent jCPrintEvent = new JCPrintEvent(this.print_table, graphics2, n + 1, this.getNumPages(), 1);
        this.table.fireJCPrintEvent(jCPrintEvent);
        graphics2.dispose();
    }

    private void doPrintEnd(Graphics graphics, int n, int n2) {
        Graphics graphics2 = graphics.create();
        int n3 = this.margin_unit == 0 ? this.page_resolution : 1;
        graphics2.setClip(n3 * this.margin.left, n2, this.table_width, this.page_height - n2 - n3 * this.margin.bottom);
        JCPrintEvent jCPrintEvent = new JCPrintEvent(this.print_table, graphics2, n + 1, this.getNumPages(), 3, this);
        this.table.fireJCPrintEvent(jCPrintEvent);
        graphics2.dispose();
    }

    private void doPrintBody(Graphics graphics, int n) {
        Graphics graphics2 = graphics.create();
        JCPrintEvent jCPrintEvent = new JCPrintEvent(this.print_table, graphics2, n + 1, this.getNumPages(), 4, this);
        this.table.fireJCPrintEvent(jCPrintEvent);
        graphics2.dispose();
    }

    private void doPrintPageFooter(Graphics graphics, int n) {
        Graphics graphics2 = graphics.create();
        int n2 = this.margin_unit == 0 ? this.page_resolution : 1;
        graphics2.setClip(n2 * this.margin.left, this.page_height - n2 * this.margin.bottom, this.table_width, n2 * this.margin.bottom);
        graphics2.translate(n2 * this.margin.left, this.page_height - n2 * this.margin.bottom);
        JCPrintEvent jCPrintEvent = new JCPrintEvent(this.print_table, graphics2, n + 1, this.getNumPages(), 2, this);
        if (JCListenerList.elements(this.table.printListeners).hasMoreElements()) {
            this.table.fireJCPrintEvent(jCPrintEvent);
        } else {
            this.printPageFooter(jCPrintEvent);
        }
        graphics2.dispose();
    }

    private void printPageFooter(JCPrintEvent jCPrintEvent) {
        Graphics graphics = jCPrintEvent.getGraphics();
        Rectangle rectangle = graphics.getClipRect();
        graphics.setFont(this.table.getFont());
        String string = "Page " + jCPrintEvent.getPage() + " of " + jCPrintEvent.getNumPages();
        graphics.drawString(string, 0, rectangle.height / 2);
    }

    private int getRowLabelWidth() {
        if (this.print_table.row_label_display) {
            return this.print_table.getColumnPixelWidth(-1);
        }
        return 0;
    }

    private int getColumnLabelHeight() {
        if (this.print_table.column_label_display) {
            return this.print_table.getRowPixelHeight(-1);
        }
        return 0;
    }
}

